In this chapter we list all the commands that you can use to get information about the activeCollab installation you are communicating with.

<{sub slug='info'}>info<{/sub}>

Returns system information about the installation you are working with. This information includes system versions; info about logged in users; the mode the API is in etc.

Method: GET

Information that you will receive when using this request is:

* api_version - Version of the activeCollab API;
* system_version - The version of activeCollab you are communicating with;
* loaded_frameworks - activeCollab loaded frameworks;
* enabled_modules - activeCollab enabled modules;
* logged_user - URL of currently logged in users (added in activeCollab 1.1.2);
* read_only - 1 if API is in read only mode, 0 if it supports both read and write requests (added in activeCollab 1.1.3).

Example response:

<{code highligh=xml}><info>
  <api_version>
    <![CDATA[3.0.0]]>
  </api_version>
  <system_version>
    <![CDATA[3.1.8]]>
  </system_version>
  <logged_user>
    <id>1</id>
    <name>
      <![CDATA[msvsbc]]>
    </name>
       ...
    <company_id>1</company_id>
    <role_id>1</role_id>
  </logged_user>
  <read_only>0</read_only>
  <loaded_frameworks> ... </loaded_frameworks>
  <enabled_modules> ... </enabled_modules>
  <max_upload_size> ... </max_upload_size>
</info><{/code}>

<{sub slug='days-off'}>info/days-off<{/sub}>

Returns list of days off.

<{note title="Compatibility Note"}>This API commands were introduced with activeCollab 3.3.12 and it is not available in the older releases.<{/note}>

Method: GET

Example response:

<{code highligh=xml}><day_offs>
  <day_off>
    <name><![CDATA[Christmas]]></name>
    <date><![CDATA[2000-12-25]]></date>
    <repeat_yearly>1</repeat_yearly>
  </day_off>
  ...
</day_offs><{/code}>

<{sub  slug='currencies'}>info/currencies<{/sub}>

Returns list of defined currencies.

<{note title="Compatibility Note"}>This API commands were introduced with activeCollab 3.3.19 and it is not available in the older releases.<{/note}>

Method: GET

Example response:

<{code highligh=xml}><currencies>
  <currency>
    <id>2</id>
    <name><![CDATA[US Dollar]]></name>
    <code><![CDATA[USD]]></code>
    <decimal_spaces>2</decimal_spaces>
    <decimal_rounding>0</decimal_rounding>
    <is_default>1</is_default>
  </currency>
  ...
</currencies><{/code}>

<{sub slug='project-labels'}>info/labels/project<{/sub}>

Lists all available project labels.

Method: GET

Example response:

<{code highlight=xml}><labels>
  <label>
    <id>1</id>
    <name>
      <![CDATA[CANCELED]]>
    </name>
    <fg_color>
      <![CDATA[#FFFFFF]]>
    </fg_color>
    <bg_color>
      <![CDATA[#FF0000]]>
    </bg_color>
  </label>
  ...
</labels><{/code}>

<{sub slug='assignment-labels'}>info/labels/assignment<{/sub}>

Lists all available assignment labels. These labels are used by tasks and subtasks.

Method: GET

Example response:

<{code highlight=xml}><labels>
  <label>
    <id>6</id>
    <name>
      <![CDATA[ASSIGNED]]>
    </name>
    <fg_color>
      <![CDATA[#FFFFFF]]>
    </fg_color>
    <bg_color>
      <![CDATA[#FF0000]]>
    </bg_color>
  </label>
   ...
</labels><{/code}>

<{sub slug='system-roles'}>info/roles<{/sub}>

Lists all system roles and role details (permissions included).

Method: GET

Example response:

<{code highlight=xml}><roles>
  <role>
    <id>7</id>
    <name>
      <![CDATA[Administrator]]>
    </name>
    ...
  </role>
  <role>
    <id>1</id>
    <name>
      <![CDATA[Administrator (+ Finances)]]>
    </name>
     ...
  <role>
    <id>6</id>
    <name>
      <![CDATA[Client Company Employee]]>
    </name>
     ...
  </role>
   ...
</roles><{/code}>

<{sub slug='roles-project'}>info/roles/project<{/sub}>

Lists all project roles and displays their permissions.

Method: GET

Example Response:

<{code highlight=xml}><roles>
<role>
    <id>2</id>
    <name>
      <![CDATA[role 1]]>
    </name>
    ...
  </role>
<role>
    <id>1</id>
    <name>
      <![CDATA[test role]]>
    </name>
    ...
  </role>
</roles><{/code}>

<{sub slug='job-types'}>info/job-types<{/sub}>

Lists all specified job types and their hourly rates.

Method: GET

Example response:

<{code highlight=xml}><job_types>
  <job_type>
    <id>1</id>
    <name><![CDATA[Programming]]></name>
    <default_hourly_rate>100</default_hourly_rate>
    <is_default>1</is_default>
  </job_type>
  ...
</job_types><{/code}>

<{sub slug='expense-categories'}>info/expense-categories<{/sub}>

Lists all defined expense categories.

Method: GET

<{note title="Compatibility"}>This API command was introduced in activeCollab 3.2.13 and it is not available in earlier versions of the software!<{/note}>

Example response:

<{code highlight=xml}><expense_categories>
  <expense_category>
    <id>1</id>
    <name><![CDATA[General]]></name>
    <is_default>1</is_default>
  </expense_category>
  ...
</expense_categories><{/code}>